import { useEffect, useState } from "react";
import { Link } from "react-router-dom";
import api from "../api/api";
import { useAuth } from "../AuthContext";


export default function TrainingListPage() {
  const { user, logout, isHrd, isAdmin } = useAuth();
  const [items, setItems] = useState([]);
  const [loading, setLoading] = useState(true);

  const loadData = async () => {
    setLoading(true);
    const res = await api.get("/training-requests");
    setItems(res.data);
    setLoading(false);
  };

  useEffect(() => {
    loadData();
  }, []);

  const handleApproveHrd = async (id) => {
    await api.post(`/training-requests/${id}/approve-hrd`, {
      hrd_notes: "",
    });
    await loadData();
  };

  const handleRejectHrd = async (id) => {
    const reason = prompt("Alasan reject HRD:");
    await api.post(`/training-requests/${id}/reject-hrd`, {
      hrd_notes: reason || "",
    });
    await loadData();
  };

  const handleApproveDirector = async (id) => {
    await api.post(`/training-requests/${id}/approve-director`);
    await loadData();
  };

  const handleRejectDirector = async (id) => {
    const reason = prompt("Catatan (opsional):");
    await api.post(`/training-requests/${id}/reject-director`, {
      hrd_notes: reason || "",
    });
    await loadData();
  };

  return (
    <div style={{ maxWidth: 900, margin: "20px auto" }}>
      <header
        style={{
          display: "flex",
          justifyContent: "space-between",
          marginBottom: 20,
        }}
      >
        <div>
          <h2>Pengajuan Training</h2>
          <div>
            Login sebagai: <strong>{user?.name}</strong> ({user?.role})<br />
            Dept: {user?.department} | Jabatan: {user?.position}
          </div>
        </div>
        <div>
          <Link to="/training/new" style={{ marginRight: 10 }}>
            + Pengajuan Baru
          </Link>
          <button onClick={logout}>Logout</button>
        </div>
      </header>

      {loading ? (
        <div>Loading...</div>
      ) : (
        <table border="1" cellPadding="6" cellSpacing="0" width="100%">
          <thead>
            <tr>
              <th>ID</th>
              <th>Nama</th>
              <th>Tanggal</th>
              <th>Vendor</th>
              <th>Biaya</th>
              <th>Status</th>
              <th>Pemohon</th>
              <th>Dept / Jabatan</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            {items.map((t) => (
              <tr key={t.id}>
                <td>{t.id}</td>
                <td>{t.title}</td>
                <td>{t.training_date}</td>
                <td>{t.vendor}</td>
                <td>{t.cost?.toLocaleString("id-ID")}</td>
                <td>{t.status}</td>
                <td>{t.user?.name}</td>
                <td>{t.user?.department} / {t.user?.position}</td>
                
                <td>
                  {/* Aksi untuk HRD */}
                    <Link to={`/training/${t.id}`} style={{ marginRight: 8 }}>
                    Detail
                    </Link>
                  {(isHrd || isAdmin) && t.status === "submitted" && (
                    <>
                      <button onClick={() => handleApproveHrd(t.id)}>
                        Approve HRD
                      </button>
                      <button onClick={() => handleRejectHrd(t.id)}>
                        Reject HRD
                      </button>
                    </>
                  )}

                  {/* Aksi Direktur (admin) untuk biaya > 20jt */}
                  {isAdmin &&
                    t.status === "approved_hrd" &&
                    t.cost > 20000000 && (
                      <>
                        <button onClick={() => handleApproveDirector(t.id)}>
                          Approve Direktur
                        </button>
                        <button onClick={() => handleRejectDirector(t.id)}>
                          Reject Direktur
                        </button>
                      </>
                    )}
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      )}
    </div>
  );
}